
#include <avr/io.h>
#include <util/delay.h>
#include <stdlib.h>


typedef uint8_t byte;

#define ClearBit(x,y) x &= ~_BV(y)
#define SetBit(x,y) x |= _BV(y)

#define LCD_RS 0
#define LCD_E 1
#define DAT4 2
#define DAT5 3
#define DAT6 4
#define DAT7 5
#define CLEARDISPLAY 0x01

void PulseEnableLine()
{
  SetBit (PORTB, LCD_E);
  _delay_us(40);
  ClearBit(PORTB, LCD_E);
}

void SendNibble(byte data)
{
  PORTB &= 0xC3;
  if (data & _BV(4)) SetBit(PORTB,DAT4);
  if (data & _BV(5)) SetBit(PORTB,DAT5);
  if (data & _BV(6)) SetBit(PORTB,DAT6);
  if (data & _BV(7)) SetBit(PORTB,DAT7);
  PulseEnableLine();
}


void SendByte(byte data)
{
  SendNibble(data);
  SendNibble(data<<4);
  ClearBit(PORTB, 5);
}

void LCD_Cmd (byte cmd)
{
  ClearBit(PORTB, LCD_RS);
  SendByte(cmd);
}

void LCD_Char (byte ch)
{
  SetBit(PORTB, LCD_RS);
  SendByte(ch);
}


void LCD_Init()
{
  LCD_Cmd(0x33);
  LCD_Cmd(0x32);
  LCD_Cmd(0x28);
  LCD_Cmd(0x0C);
  LCD_Cmd(0x06);
  LCD_Cmd(0x01);
  _delay_ms(3);
}


void LCD_Clear()
{
  LCD_Cmd(CLEARDISPLAY);
  _delay_ms(3);
}


void LCD_Message(const char *text)
{
  LCD_Char(*text++);
}

void LCD_Integer(int data)
{
  char st[8] = "";
  itoa(data, st, 10);
  LCD_Message(st);
}

int main(void)
{
  DDRB = 0xFF;
  LCD_Init();
  
  while(1)
  {
    LCD_Clear();
    LCD_Integer(5);
    _delay_ms(600);
  }

}


